/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.security.IVWRecipientSelectionPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientComboPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientFilterPanel;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class VWAssignWorkDialog
extends VWModalDialog
implements ItemListener,
ActionListener {
    private VWTrkDataModel m_trackerDataModel = null;
    private VWStepNParticipantRenderer m_stepAndParticipantRenderer = new VWStepNParticipantRenderer();
    private Vector m_activeSteps = null;
    private Object m_selected = null;
    private VWTrkParticipant m_selectedParticipant = null;
    private String m_queueName = null;
    private JLabel m_stepLabel = null;
    private JComboBox m_stepCombo = null;
    private DefaultComboBoxModel m_stepModel = null;
    private JLabel m_fromLabel = null;
    private JComboBox m_participantCombo = null;
    private DefaultComboBoxModel m_participantModel = null;
    private String m_selecteAParticipant = VWResource.s_selectAParticipant;
    private String m_noParticipant;
    private String m_nullParticipantString = this.m_noParticipant = null;
    private boolean m_initializingParticipantModel = false;
    private IVWRecipientSelectionPanel m_recipientSelectionPanel = null;
    private JCheckBox m_approveWorkCheckBox = new JCheckBox(VWResource.s_approveWork);
    private JLabel m_commentsLabel = null;
    private JTextArea m_commentsUI = null;
    private JTextArea m_newCommentsUI = null;
    private JRadioButton m_appendRadio = null;
    private JRadioButton m_replaceRadio = null;
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;

    public VWAssignWorkDialog(Frame parentFrame, VWTrkDataModel trackerDataModel) throws Exception {
        super(parentFrame);
        this.m_trackerDataModel = trackerDataModel;
        if (trackerDataModel == null) {
            throw new Exception(VWResource.s_nullTrackerDataModel.toString(VWResource.s_assignWorkDialogTitle));
        }
        this.initData();
        this.setupLayout();
        this.updateControls();
        Vector selectedSteps = trackerDataModel.getSelectedSteps();
        if (selectedSteps != null && selectedSteps.size() > 0 && this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < selectedSteps.size(); ++i) {
                VWTrkStep step;
                Vector occurrences;
                Object obj = selectedSteps.elementAt(i);
                if (obj == null || (occurrences = (step = (VWTrkStep)obj).getActiveOccurrences()) == null) continue;
                if (occurrences.size() > 1) {
                    obj = occurrences.elementAt(0);
                }
                if (this.m_stepModel.getIndexOf(obj) < 0) continue;
                Object selected = this.m_stepModel.getSelectedItem();
                if (selected == obj) break;
                this.m_stepModel.setSelectedItem(obj);
                break;
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_stepLabel.setFont(boldFont);
            this.m_fromLabel.setFont(boldFont);
        }
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public boolean isCanReassignWork() {
        return this.m_activeSteps != null && this.m_activeSteps.size() > 0;
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource().equals(this.m_stepCombo)) {
            if (event.getStateChange() == 1) {
                this.performStepSelected();
                this.setButtonState();
            }
        } else if (event.getSource().equals(this.m_participantCombo)) {
            if (this.m_initializingParticipantModel) {
                return;
            }
            if (event.getStateChange() == 1) {
                this.performParticipantSelected();
                this.setButtonState();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_recipientSelectionPanel)) {
            this.setButtonState();
        } else if (event.getSource().equals(this.m_okButton)) {
            this.m_bCanceled = false;
            this.performAssignReassign();
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_applyButton)) {
            this.performAssignReassign();
            this.m_recipientSelectionPanel.reset();
            this.removeParticipantSeleciton();
            this.setButtonState();
        } else if (event.getSource().equals(this.m_closeButton)) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt034.htm");
        }
    }

    private void initData() throws Exception {
        VWTrkStep obj;
        int i;
        VWTrkStepOccurrence occurrence = null;
        this.m_activeSteps = this.m_trackerDataModel.getActiveSteps();
        if (this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            Object step = null;
            for (i = this.m_activeSteps.size() - 1; i >= 0; --i) {
                obj = (VWTrkStep)this.m_activeSteps.elementAt(i);
                if (obj != null && obj instanceof VWTrkStep && obj.getCanReassign()) continue;
                this.m_activeSteps.removeElementAt(i);
            }
        }
        if (this.m_participantModel != null) {
            this.m_participantModel.removeAllElements();
        } else {
            this.m_participantModel = new DefaultComboBoxModel();
        }
        if (this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            this.m_stepModel = new DefaultComboBoxModel();
            for (int i2 = 0; i2 < this.m_activeSteps.size(); ++i2) {
                Vector occurrences;
                Object obj2 = this.m_activeSteps.elementAt(i2);
                if (obj2 == null || !(obj2 instanceof VWTrkStep) || (occurrences = ((VWTrkStep)obj2).getActiveOccurrences()) == null || occurrences.size() <= 0) continue;
                if (occurrences.size() == 1) {
                    this.m_stepModel.addElement(obj2);
                    continue;
                }
                for (int j = 0; j < occurrences.size(); ++j) {
                    if (occurrences.elementAt(j) == null) continue;
                    this.m_stepModel.addElement(occurrences.elementAt(j));
                }
            }
            this.m_selected = this.m_stepModel.getElementAt(0);
            occurrence = this.getSelectedOccurrence();
        } else {
            this.m_stepModel = new DefaultComboBoxModel();
            this.m_selected = null;
            occurrence = null;
        }
        if (occurrence != null) {
            Vector participants = null;
            if (occurrence != null) {
                participants = occurrence.getActiveParticipants();
            }
            this.m_queueName = null;
            if (participants != null && participants.size() > 0) {
                for (i = 0; i < participants.size(); ++i) {
                    obj = participants.elementAt(i);
                    if (!(obj instanceof VWTrkParticipant)) continue;
                    VWTrkParticipant participant = (VWTrkParticipant)((Object)obj);
                    if (this.m_queueName == null) {
                        this.m_queueName = participant.getQueueName();
                    }
                    if (participant.isLockedByOther()) continue;
                    int loc = this.m_participantModel.getSize();
                    VWParticipant vwParticipant = participant.getParticipant();
                    for (int j = 0; j < this.m_participantModel.getSize(); ++j) {
                        VWTrkParticipant p = (VWTrkParticipant)this.m_participantModel.getElementAt(j);
                        VWParticipant vwTempParticipant = p.getParticipant();
                        if (VWStringUtils.compareIgnoreCase(vwParticipant.getParticipantName(), vwTempParticipant.getParticipantName()) > 0) continue;
                        loc = j;
                        break;
                    }
                    if (loc >= this.m_participantModel.getSize()) {
                        this.m_participantModel.addElement(participant);
                        continue;
                    }
                    this.m_participantModel.insertElementAt(participant, loc);
                }
            }
            this.m_nullParticipantString = this.m_participantModel.getSize() > 0 ? this.m_selecteAParticipant : this.m_noParticipant;
            this.m_selectedParticipant = null;
        }
    }

    private VWTrkStepOccurrence getSelectedOccurrence() {
        Vector occurrences;
        if (this.m_selected == null) {
            return null;
        }
        if (this.m_selected instanceof VWTrkStepOccurrence) {
            return (VWTrkStepOccurrence)this.m_selected;
        }
        if (this.m_selected instanceof VWTrkStep && (occurrences = ((VWTrkStep)this.m_selected).getActiveOccurrences()) != null && occurrences.size() > 0) {
            return (VWTrkStepOccurrence)occurrences.elementAt(0);
        }
        return null;
    }

    private VWTrkStep getSelectedStep() {
        if (this.m_selected == null) {
            return null;
        }
        if (this.m_selected instanceof VWTrkStepOccurrence) {
            return ((VWTrkStepOccurrence)this.m_selected).getStep();
        }
        if (this.m_selected instanceof VWTrkStep) {
            return (VWTrkStep)this.m_selected;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAssignReassign() {
        block23: {
            VWTrkStepOccurrence occurrence = this.getSelectedOccurrence();
            Cursor currentCursor = null;
            try {
                if (occurrence == null) break block23;
                currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                VWParticipant selectedUser = null;
                if (this.m_recipientSelectionPanel != null) {
                    selectedUser = this.m_recipientSelectionPanel.getSelectedValue();
                }
                String comments = null;
                boolean bDelegate = false;
                this.m_selectedParticipant = (VWTrkParticipant)this.m_participantCombo.getSelectedItem();
                if (selectedUser == null || this.m_selectedParticipant == null) break block23;
                boolean bLocked = this.m_selectedParticipant.isLockedByCurrentUser();
                try {
                    if (!bLocked) {
                        this.m_selectedParticipant.doLock(false);
                    }
                    if (this.m_selectedParticipant.isLockedByCurrentUser()) {
                        String newComments = this.m_newCommentsUI.getText();
                        if (this.m_appendRadio.isSelected()) {
                            try {
                                comments = this.m_selectedParticipant.getComments();
                            }
                            catch (VWException ex) {
                                // empty catch block
                            }
                            if (comments == null) {
                                comments = "";
                            }
                            if (newComments != null && newComments.length() > 0) {
                                if (comments.length() > 0) {
                                    comments = comments + "\n";
                                }
                                comments = comments + newComments;
                            }
                        } else {
                            comments = newComments != null ? newComments : null;
                        }
                        if (this.m_approveWorkCheckBox.isEnabled() && this.m_approveWorkCheckBox.isSelected()) {
                            bDelegate = true;
                        }
                        this.m_selectedParticipant.doReassign(selectedUser, comments, bDelegate, "Inbox");
                        this.m_selected = null;
                        this.performStepSelected();
                        if (this.m_recipientSelectionPanel != null) {
                            this.m_recipientSelectionPanel.reset();
                        }
                        this.m_newCommentsUI.setText(null);
                        break block23;
                    }
                    if (!bLocked) {
                        this.m_selectedParticipant.unlockWork(false, false);
                    }
                    JOptionPane.showMessageDialog(this, VWResource.s_failedToPerfomTask.toString(VWResource.s_unableToLock), VWResource.s_assignWorkDialogTitle, 0, null);
                }
                catch (VWException ex) {
                    if (!bLocked) {
                        this.m_selectedParticipant.unlockWork(false, false);
                    }
                    JOptionPane.showMessageDialog(this, VWResource.s_failedToPerfomTask.toString(ex.getLocalizedMessage()), VWResource.s_assignWorkDialogTitle, 0, null);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                String msg = ex.getLocalizedMessage();
                if (msg == null || msg.length() == 0) {
                    msg = ex.getClass().getName();
                }
                JOptionPane.showMessageDialog(this, msg, VWResource.s_assignWorkDialogTitle, 0, null);
            }
            finally {
                if (currentCursor != null) {
                    this.setCursor(currentCursor);
                }
                this.m_newCommentsUI.setText(null);
            }
        }
    }

    private void performParticipantSelected() {
        if (this.m_initializingParticipantModel) {
            return;
        }
        int index = this.m_participantCombo.getSelectedIndex();
        Object obj = this.m_participantCombo.getSelectedItem();
        this.m_selectedParticipant = (VWTrkParticipant)this.m_participantModel.getElementAt(index);
        this.updateControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performStepSelected() {
        this.removeParticipantSeleciton();
        try {
            this.m_initializingParticipantModel = true;
            Object selected = this.m_stepCombo.getSelectedItem();
            this.m_participantModel.removeAllElements();
            if (selected != this.m_selected) {
                VWTrkStepOccurrence occurrence = null;
                this.m_selected = selected;
                occurrence = this.getSelectedOccurrence();
                if (occurrence != null) {
                    Vector participants = occurrence.getActiveParticipants();
                    if (participants != null) {
                        this.m_participantModel.removeAllElements();
                        for (int i = 0; i < participants.size(); ++i) {
                            Object obj = participants.elementAt(i);
                            if (!(obj instanceof VWTrkParticipant)) continue;
                            VWTrkParticipant participant = (VWTrkParticipant)obj;
                            if (this.m_queueName == null) {
                                this.m_queueName = participant.getQueueName();
                            }
                            if (!participant.getCanReassign() || participant.isLockedByOther()) continue;
                            int loc = this.m_participantModel.getSize();
                            VWParticipant vwParticipant = participant.getParticipant();
                            if (vwParticipant == null || vwParticipant.getParticipantName() == null) {
                                loc = 0;
                            } else {
                                for (int j = 0; j < this.m_participantModel.getSize(); ++j) {
                                    VWTrkParticipant p = (VWTrkParticipant)this.m_participantModel.getElementAt(j);
                                    VWParticipant tempParticipant = p.getParticipant();
                                    if (tempParticipant == null || tempParticipant.getParticipantName() == null || VWStringUtils.compareIgnoreCase(vwParticipant.getParticipantName(), tempParticipant.getParticipantName()) > 0) continue;
                                    loc = j;
                                    break;
                                }
                            }
                            if (loc >= this.m_participantModel.getSize()) {
                                this.m_participantModel.addElement(participant);
                                continue;
                            }
                            this.m_participantModel.insertElementAt(participant, loc);
                        }
                        this.m_nullParticipantString = this.m_participantModel.getSize() > 0 ? this.m_selecteAParticipant : this.m_noParticipant;
                        this.m_selectedParticipant = null;
                        this.m_participantCombo.setSelectedIndex(-1);
                        return;
                    }
                    this.m_selectedParticipant = null;
                } else {
                    this.m_selectedParticipant = null;
                }
                this.updateControls();
            }
        }
        finally {
            this.m_initializingParticipantModel = false;
        }
    }

    private void setButtonState() {
        boolean bEnable = false;
        int index = this.m_participantCombo.getSelectedIndex();
        if (index != -1 && this.m_recipientSelectionPanel.hasValidSelection()) {
            bEnable = true;
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private void setupLayout() {
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_assignWorkDialogDim);
        if (dim == null) {
            dim = new Dimension(450, 450);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_assignWorkDialogTitle);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(4, 0, 4, 4);
        this.m_stepLabel = new JLabel(VWResource.s_label.toString(VWResource.s_step));
        mainPanel.add((Component)this.m_stepLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.m_stepCombo = new JComboBox(this.m_stepModel);
        this.m_stepCombo.addItemListener(this);
        this.m_stepCombo.setRenderer(this.m_stepAndParticipantRenderer);
        mainPanel.add((Component)this.m_stepCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_fromLabel = new JLabel(VWResource.s_label.toString(VWResource.s_from));
        mainPanel.add((Component)this.m_fromLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.m_participantCombo = new JComboBox(this.m_participantModel);
        this.m_participantCombo.addItemListener(this);
        this.m_participantCombo.setRenderer(new VWStepNParticipantRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                if (value == null) {
                    value = VWAssignWorkDialog.this.m_nullParticipantString;
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
            }
        });
        this.removeParticipantSeleciton();
        mainPanel.add((Component)this.m_participantCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 23;
        mainPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_to)), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 2.0;
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(4, 0, 0, 4);
        try {
            this.m_recipientSelectionPanel = VWDefaultSessionProxy.getSession().getSecurityDatabaseType() == 1 ? new VWRecipientFilterPanel(this, VWDefaultSessionProxy.getSession()) : new VWRecipientComboPanel(this, VWDefaultSessionProxy.getSession());
            this.m_recipientSelectionPanel.addActionListener(this);
            mainPanel.add((Component)((JPanel)((Object)this.m_recipientSelectionPanel)), c);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        JPanel commentsPanel = new JPanel();
        this.setupCommentsPanel(commentsPanel);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 3.0;
        c.insets = new Insets(4, 0, 0, 0);
        c.fill = 1;
        mainPanel.add((Component)commentsPanel, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 4, 4);
        c.fill = 0;
        mainPanel.add((Component)this.m_approveWorkCheckBox, c);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_okButton.addActionListener(this);
        buttonPanel.add(this.m_okButton);
        this.m_applyButton = new JButton(VWResource.s_apply);
        this.m_applyButton.addActionListener(this);
        buttonPanel.add(this.m_applyButton);
        this.m_closeButton = new JButton(VWResource.s_close);
        this.m_closeButton.addActionListener(this);
        buttonPanel.add(this.m_closeButton);
        this.m_helpButton = new JButton(VWResource.s_help);
        this.m_helpButton.addActionListener(this);
        buttonPanel.add(this.m_helpButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "Last");
        this.setButtonState();
    }

    private void setupCommentsPanel(JPanel panel) {
        this.m_commentsUI = new JTextArea();
        this.m_commentsUI.setLineWrap(true);
        this.m_commentsUI.setWrapStyleWord(false);
        this.m_commentsUI.setEditable(false);
        this.m_newCommentsUI = new JTextArea();
        this.m_newCommentsUI.setLineWrap(true);
        this.m_newCommentsUI.setWrapStyleWord(false);
        ButtonGroup grp = new ButtonGroup();
        this.m_appendRadio = new JRadioButton(VWResource.s_append);
        this.m_replaceRadio = new JRadioButton(VWResource.s_replace);
        grp.add(this.m_appendRadio);
        grp.add(this.m_replaceRadio);
        this.m_appendRadio.setSelected(true);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_label.toString(VWResource.s_comments)));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 0, 0);
        panel.add((Component)this.m_appendRadio, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        panel.add((Component)this.m_replaceRadio, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 6, 0, 0);
        c.anchor = 23;
        c.fill = 0;
        panel.add((Component)new JLabel(VWResource.s_currentComments), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_commentsUI), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel(VWResource.s_enterComments), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_newCommentsUI), c);
    }

    private void updateControls() {
        if (this.m_selected != null) {
            VWTrkStep selectedStep = this.getSelectedStep();
            boolean bQueueStep = selectedStep.isQueueStep();
            String queueName = selectedStep.getQueueName();
            if (queueName == null || VWStringUtils.compare(queueName, "") == 0) {
                bQueueStep = false;
            }
            if (this.m_selectedParticipant != null) {
                this.m_participantCombo.setEnabled(true);
                if (this.m_recipientSelectionPanel != null) {
                    this.m_recipientSelectionPanel.setEnabled(true);
                }
                this.m_commentsUI.setEnabled(true);
                VWParticipant participant = this.m_selectedParticipant.getParticipant();
                this.m_approveWorkCheckBox.setEnabled(participant != null && participant.getParticipantName() != null);
                String comments = null;
                try {
                    comments = this.m_selectedParticipant.getComments();
                }
                catch (VWException ex) {
                    comments = "";
                }
                this.m_commentsUI.setText(comments);
            } else {
                this.m_commentsUI.setText(null);
                this.m_commentsUI.setEnabled(false);
            }
        } else {
            if (this.m_recipientSelectionPanel != null) {
                this.m_recipientSelectionPanel.setEnabled(false);
            }
            this.m_commentsUI.setEnabled(false);
        }
        this.setButtonState();
    }

    private void removeParticipantSeleciton() {
        if (this.m_participantCombo != null) {
            this.m_participantCombo.setSelectedIndex(-1);
        }
        if (this.m_commentsUI != null) {
            this.m_commentsUI.setText(null);
        }
    }
}

